<?php

namespace App\Http\Controllers\admin;

use App\Models\User;
use App\Models\Karyawan;
use App\Models\JatahCuti;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class JatahCutiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $jatahCuti = JatahCuti::all();
        $karyawan = Karyawan::all();
        $user = User::all();
        return view('admin.jatah-cuti.index', compact('jatahCuti', 'karyawan', 'user'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
        $request->validate([
            'karyawan_id'   => 'required|exists:karyawan,id',
            'tahun'        => 'required',
            'jatah'   => 'required',
        ]);

        JatahCuti::create([
            'karyawan_id'   => $request->karyawan_id,
            'tahun'        => $request->tahun,
            'jatah'   => $request->jatah,
        ]);

            return redirect()->back()->with('success', 'Jatah cuti berhasil ditambahkan');

        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Gagal menambahkan jadwal cuti!');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Jatahcuti $id)
    {
    try {
        $request->validate([
            'karyawan_id'   => 'required|exists:karyawan,id',
            'tahun'        => 'required',
            'jatah'   => 'required',
        ]);

        $jatahCuti->update([
            'karyawan_id'   => $request->karyawan_id,
            'tahun'        => $request->tahun,
            'jatah'   => $request->jatah,
        ]);


            return redirect()->back()->with('success', 'Jatah cuti berhasil diperbarui');

        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Gagal memperbarui jatah cuti!');
        }    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(JatahCuti $id)
    {
        try {
            $jadwalCuti->delete();
            return redirect()->back()->with('success', 'Jatah cuti berhasil dihapus');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Jatah cuti gagal dihapus');
        }
    }
}
